/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import java.util.Date;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.logs.LRCTFMatch;
import org.metabit.tools.games.lrctf.stats.PlayerStats;
import org.metabit.tools.games.lrctf.stats.SlotToNameMap;
import org.metabit.tools.games.lrctf.stats.StatsSet;

public class TimeIntervalStats
extends StatsSet {
    protected Vector matchrelative_slotNameMap = new Vector();
    protected long fromTime;
    protected long untilTime;
    protected long numMatches = 0L;
    protected SortedMap namePlayerMap = new TreeMap();

    public TimeIntervalStats(Date startDate, Date endDate) {
        this.fromTime = startDate.getTime();
        this.untilTime = endDate.getTime();
        if (this.fromTime >= this.untilTime) {
            throw new IllegalArgumentException("start date must be before end date");
        }
    }

    public TimeIntervalStats(Date startDate, long secondsAfterThat) {
        this.fromTime = startDate.getTime();
        this.untilTime = this.fromTime + secondsAfterThat * 1000L;
    }

    public TimeIntervalStats() {
        this.fromTime = 0L;
        this.untilTime = Long.MAX_VALUE;
    }

    public boolean processMatch(LRCTFMatch match) {
        Date msd = match.getMatchStart();
        Date med = match.getMatchEnd();
        if (msd == null || med == null) {
            System.err.println("we got a match without proper start or end date here!");
            System.err.println(match.toString());
            return false;
        }
        long msl = msd.getTime();
        long mel = med.getTime();
        if (msl >= this.untilTime) {
            return false;
        }
        if (mel < this.fromTime) {
            return false;
        }
        SlotToNameMap slotNames = new SlotToNameMap();
        PlayerStats player = null;
        String playerName = null;
        Iterator it = match.iterator();
        while (it.hasNext()) {
            LRCTFLogEntry entry = (LRCTFLogEntry)it.next();
            int slotNumber = slotNames.processLogEntry(entry);
            if (slotNumber < 0 || (playerName = slotNames.getName(slotNumber)) == null) continue;
            player = this.getPlayerStatsForName(playerName);
            player.processLogEntry(entry);
        }
        long durationInSeconds = (mel - msl) / 1000L;
        int num = slotNames.size();
        for (int i = 0; i < num; ++i) {
            playerName = slotNames.getName(i);
            if (playerName == null) continue;
            player = this.getPlayerStatsForName(playerName);
            player.processMatchInGeneral(durationInSeconds);
        }
        ++this.numMatches;
        return true;
    }

    public Date getIntervalStartDate() {
        return new Date(this.fromTime);
    }

    public Date getIntervalEndDate() {
        return new Date(this.untilTime);
    }

    public PlayerStats getPlayerStatsForName(String name, boolean create) {
        PlayerStats ps = null;
        Object obj = this.namePlayerMap.get(name);
        if (obj == null) {
            if (!create) {
                return null;
            }
            ps = new PlayerStats();
            this.namePlayerMap.put(name, ps);
        } else {
            ps = (PlayerStats)obj;
        }
        return ps;
    }

    public final PlayerStats getPlayerStatsForName(String name) {
        return this.getPlayerStatsForName(name, true);
    }

    public final Iterator getPlayerStatsIterator() {
        return this.namePlayerMap.values().iterator();
    }
}

