/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.metabit.tools.games.lrctf.stats.StatsItem;
import org.metabit.tools.games.lrctf.stats.StatsItemCounter;
import org.metabit.tools.games.lrctf.stats.StatsItemInt;
import org.metabit.tools.games.lrctf.stats.StatsItemTime;

public class StatsSet
implements StatsItem {
    protected Vector containedStatsItems;

    public int getType() {
        return 16;
    }

    public boolean isContainer() {
        return true;
    }

    public Iterator getElements() {
        return this.containedStatsItems.iterator();
    }

    public StatsSet() {
        this.containedStatsItems = new Vector();
    }

    public StatsSet(int maxIndex) {
        this.containedStatsItems = new Vector(maxIndex);
    }

    public void initSingleItem(int index, StatsItem obj) {
        if (index >= this.containedStatsItems.size()) {
            this.containedStatsItems.setSize(index + 1);
        }
        this.containedStatsItems.set(index, obj);
    }

    public void createCounterItem(int index) {
        this.initSingleItem(index, new StatsItemCounter());
    }

    public void createIntItem(int index) {
        this.initSingleItem(index, new StatsItemInt());
    }

    public void createTimeItem(int index) {
        this.initSingleItem(index, new StatsItemTime());
    }

    public StatsItem getItem(int index) {
        return (StatsItem)this.containedStatsItems.get(index);
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.containedStatsItems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            StatsItem si = (StatsItem)obj;
            sb.append(si.toDebugString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void updateCounterItem(int index) {
        StatsItem si = this.getItem(index);
        StatsItemCounter sic = (StatsItemCounter)si;
        sic.increment();
    }

    public void updateIntItem(int index, int value) {
        StatsItem si = this.getItem(index);
        StatsItemInt sii = (StatsItemInt)si;
        sii.update(value);
    }

    public void updateTimeItem(int index, long seconds) {
        StatsItem si = this.getItem(index);
        StatsItemTime sit = (StatsItemTime)si;
        sit.update(seconds);
    }

    public void updateTimeItemWithDateInterval(int index, Date start, Date end) {
        StatsItem si = this.getItem(index);
        StatsItemTime sit = (StatsItemTime)si;
        sit.updateWithDateInterval(start, end);
    }
}

