/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import org.metabit.tools.games.lrctf.stats.StatsItemNumberBase;

public class StatsItemInt
extends StatsItemNumberBase {
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private double produkt = 1.0;

    public final int getType() {
        return 2;
    }

    public boolean isContainer() {
        return false;
    }

    public void update(int newValue) {
        this.summe += (long)newValue;
        if (this.produkt != 0.0) {
            this.produkt = newValue > 0 ? (this.produkt *= (double)newValue) : 0.0;
        }
        if (this.min > newValue) {
            this.min = newValue;
        }
        if (this.max < newValue) {
            this.max = newValue;
        }
        ++this.count;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public double getGeometricMean() {
        if (this.produkt == 0.0) {
            return Double.NaN;
        }
        double res = Math.pow(this.produkt, -this.count);
        return res;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.count);
        sb.append(" Eintr\u00e4ge,\tSumme= ");
        sb.append(this.summe);
        sb.append(",\teinfacher Mittelwert: ");
        sb.append(this.getArithmeticMean());
        sb.append(",\tMinimum: ");
        sb.append(this.getMinimum());
        sb.append(",\tMaximum: ");
        sb.append(this.getMaximum());
        return sb.toString();
    }
}

