/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.metabit.tools.games.lrctf.LRCTFFileFilter;
import org.metabit.tools.games.lrctf.logs.LRCTFMatch;
import org.metabit.tools.games.lrctf.stats.TimeIntervalStats;

public class Statistics {
    private Vector intervalStats = new Vector();

    public void finalize() {
        this.intervalStats.clear();
        this.intervalStats = null;
        System.gc();
    }

    public Iterator iterator() {
        return this.intervalStats.iterator();
    }

    public void add(TimeIntervalStats tis) {
        this.intervalStats.addElement(tis);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LRCTF Statistics: \n");
        Iterator it = this.intervalStats.iterator();
        while (it.hasNext()) {
            sb.append("-\t");
            TimeIntervalStats tis = (TimeIntervalStats)it.next();
            sb.append(tis.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean processFilesForStats(File storedir, String extension) {
        return Statistics.processFilesForStats(storedir, extension, this.intervalStats);
    }

    public static boolean processFilesForStats(File storedir, String extension, List stats) {
        if (!storedir.isDirectory()) {
            return false;
        }
        LRCTFFileFilter tf = new LRCTFFileFilter(extension);
        File[] files = storedir.listFiles(tf);
        System.out.println("-- processing " + files.length + " files of type " + extension);
        if (files.length == 0) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                LRCTFMatch m = new LRCTFMatch();
                FileInputStream ifstr = new FileInputStream(files[i]);
                m.readFromStream(ifstr);
                if (m == null) {
                    System.out.println(i + ". :\t" + files[i].getName() + "\t could not be read");
                    continue;
                }
                Iterator statsIterator = stats.iterator();
                while (statsIterator.hasNext()) {
                    TimeIntervalStats tis = (TimeIntervalStats)statsIterator.next();
                    tis.processMatch(m);
                }
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe.getLocalizedMessage());
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.err.println(fnfe.getLocalizedMessage());
                continue;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getLocalizedMessage());
            }
        }
        return true;
    }
}

