/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import java.util.Properties;
import java.util.Vector;
import org.metabit.tools.games.lrctf.Constants;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.logs.LogEntryHelper;

public class SlotToNameMap {
    private Vector slots = new Vector();

    public void putName(int number, String name) {
        if (number >= this.slots.size()) {
            this.slots.setSize(number + 1);
        }
        this.slots.set(number, name);
    }

    public String getName(int number) {
        if (number >= this.slots.size()) {
            return null;
        }
        return (String)this.slots.get(number);
    }

    public int getNumber(String name) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (name.compareTo(this.getName(i)) != 0) continue;
            return i;
        }
        return -1;
    }

    public int processLogEntry(LRCTFLogEntry logEntry) {
        int key = logEntry.getKey();
        switch (key) {
            case 6: {
                return this.process_ClientUserInfoChanged(logEntry);
            }
            case 10: {
                return this.process_say(logEntry);
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                if (!Constants.isKeyPlayerStatsRelevant(key)) break;
                return logEntry.getData(LRCTFLogEntry.D_PLAYER);
            }
        }
        return -1;
    }

    private int process_ClientUserInfoChanged(LRCTFLogEntry logEntry) {
        int playerID = logEntry.getData(LRCTFLogEntry.D_PLAYER);
        String text = logEntry.getText();
        Properties prop = LogEntryHelper.parseUserinfoChangeText(text);
        String playerName = prop.getProperty("n", null);
        if (playerName != null) {
            this.putName(playerID, playerName);
        }
        return playerID;
    }

    private int process_say(LRCTFLogEntry logEntry) {
        int playerID = logEntry.getData(LRCTFLogEntry.D_PLAYER);
        String text = logEntry.getText();
        int sepIdx = text.indexOf(58);
        if (sepIdx <= 0) {
            return -2;
        }
        String pname = text.substring(0, sepIdx);
        if (playerID != 0 && pname.trim().length() > 0) {
            this.putName(playerID, pname);
        }
        return playerID;
    }

    public boolean isEmpty() {
        return this.slots.isEmpty();
    }

    public int size() {
        return this.slots.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SlotToNameMap with " + this.slots.size() + " entries:");
        for (int i = 0; i < this.slots.size(); ++i) {
            sb.append(i);
            sb.append("\t: ");
            sb.append(this.getName(i));
            sb.append("\n");
        }
        return sb.toString();
    }
}

