/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import java.util.Iterator;
import java.util.Properties;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.logs.LogEntryHelper;
import org.metabit.tools.games.lrctf.stats.KeyToStatsItemMap;
import org.metabit.tools.games.lrctf.stats.StatsItem;
import org.metabit.tools.games.lrctf.stats.StatsItemCounter;
import org.metabit.tools.games.lrctf.stats.StatsSet;

public class PlayerStats
extends StatsSet {
    public static final int PS_TIME_CONNECTED = 0;
    public static final int PS_NUMBER_MATCHES_PLAYED = 1;
    String GUID;
    String myName;
    KeyToStatsItemMap playerstatitems;
    KeyToStatsItemMap weapons;

    public PlayerStats() {
        this.playerstatitems = new KeyToStatsItemMap();
        this.weapons = new KeyToStatsItemMap();
        this.createTimeItem(0);
        this.createCounterItem(1);
    }

    public PlayerStats(String name) {
        this.myName = name;
    }

    public PlayerStats(int slot, String name) {
        this.myName = name;
    }

    public int processLogEntry(LRCTFLogEntry logEntry) {
        int actions = 0;
        int key = logEntry.getKey();
        switch (key) {
            case 6: {
                this.event_UserinfoChanged(logEntry);
                break;
            }
            case 12: {
                this.event_incrementCounter(this.playerstatitems, key);
                this.event_incrementCounter(this.weapons, logEntry.getData(LRCTFLogEntry.D_WEAPON));
                break;
            }
            case 22: {
                this.event_incrementCounter(this.playerstatitems, key);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.event_incrementCounter(this.playerstatitems, key);
                break;
            }
        }
        return actions;
    }

    public void processMatchInGeneral(long durationInSeconds) {
        this.updateTimeItem(0, durationInSeconds);
        this.updateCounterItem(1);
    }

    public void event_incrementCounter(KeyToStatsItemMap ktsim, int actionKey) {
        StatsItem si = ktsim.get(actionKey);
        if (si == null) {
            StatsItemCounter sic = new StatsItemCounter();
            sic.increment();
            ktsim.put(actionKey, sic);
        } else if (si.getType() != 1) {
            System.err.println("problem. a StatsItem changed its type runtime... to: " + si.getType());
        } else {
            StatsItemCounter sic = (StatsItemCounter)si;
            sic.increment();
        }
    }

    public void event_UserinfoChanged(LRCTFLogEntry entry) {
        String playerName;
        int playerID = entry.getData(LRCTFLogEntry.D_PLAYER);
        String text = entry.getText();
        Properties prop = LogEntryHelper.parseUserinfoChangeText(text);
        this.myName = playerName = prop.getProperty("n", null);
    }

    public String getPrimaryName() {
        return this.myName;
    }

    public boolean hasKills() {
        StatsItem si = this.playerstatitems.get(12);
        if (si == null) {
            return false;
        }
        if (si.getType() != 1) {
            System.err.println("Stats item KILL changed its type!");
            return false;
        }
        StatsItemCounter sic = (StatsItemCounter)si;
        return sic.getValue() > 0;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer("PlayerStats\n");
        Iterator it = this.playerstatitems.getKeys();
        while (it.hasNext()) {
            Integer ikey = (Integer)it.next();
            sb.append("#");
            sb.append(ikey);
            sb.append(":");
            sb.append(this.playerstatitems.get(ikey));
            sb.append("\n");
        }
        return sb.toString();
    }

    public KeyToStatsItemMap getStatsItemMap() {
        return this.playerstatitems;
    }

    public KeyToStatsItemMap getWeaponsMap() {
        return this.weapons;
    }
}

