/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.stats.PlayerStats;

public class MatchStats {
    private String mapName = null;
    private long duration = -1L;
    private Date startDate = null;
    private Date endDate = null;
    private Vector slots = new Vector();

    public int processLogEntry(LRCTFLogEntry logEntry) {
        int actions = 0;
        int playerNum = -1;
        if (playerNum >= 0) {
            PlayerStats player = this.getOrCreateSlotEntry(playerNum);
            actions += player.processLogEntry(logEntry);
        }
        return actions;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Match Stats");
        sb.append("\nMapname = ");
        sb.append(this.mapName);
        sb.append("\nDuration: ");
        sb.append(this.duration);
        sb.append("\t(Start ");
        sb.append(this.startDate);
        sb.append(", End");
        sb.append(this.endDate);
        sb.append(")\n");
        Iterator it = this.slots.iterator();
        while (it.hasNext()) {
            PlayerStats ps = (PlayerStats)it.next();
            sb.append(ps.toDebugString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public PlayerStats getOrCreateSlotEntry(int slotNumber) {
        PlayerStats se;
        if (slotNumber >= this.slots.size()) {
            this.slots.setSize(slotNumber + 1);
        }
        if ((se = (PlayerStats)this.slots.get(slotNumber)) == null) {
            se = new PlayerStats();
            this.slots.setElementAt(se, slotNumber);
        }
        return se;
    }

    public PlayerStats getSlotEntryOrNull(int slotNumber) {
        if (slotNumber >= this.slots.size()) {
            return null;
        }
        return (PlayerStats)this.slots.get(slotNumber);
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public String toString() {
        return this.toDebugString();
    }
}

