/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.stats;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.metabit.tools.games.lrctf.html.LROutputHelperHTML;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;

public class MatchResult
implements Serializable {
    public static final int MATCHRESULT_STATE_UNDEFINED = -1;
    public static final int MATCHRESULT_STATE_EMPTY = 0;
    public static final int MATCHRESULT_STATE_INITIALIZED = 1;
    static final String LINEFORMATSTRING = "#{0,number,##0.#}\t{2,number,###0.#}\t{3,number,###0.#}\t{4,number,###}\t{5,number,###}\t{6,number,####}\t{1}\n";
    static final String FIRSTLINEMESSAGE = "Slot\tscore\toffense\tdefense\tfrags\tping\n";
    static final String HTML_FIRSTLINEMESSAGE = "<tr><th>Slot</th><th>score</th><th>offense</th><th>defense</th><th>frags</th><th>ping</th></tr>";
    static final String HTML_LINEFORMATSTRING = "<tr><td>#{0,number,##0.#}</td><td>{2,number,###0.#}</td><td>{3,number,###0.#}</td><td>{4,number,###}</td><td>{5,number,###}</td><td>{6,number,####}</td><td>{1}\n</td></tr>";
    int state = 0;
    private Vector slotData = new Vector();
    Date matchEnded = null;
    int exitReason = 0;
    int red = -1;
    int blue = -1;
    int MVPO_player = -1;
    int MVPD_player = -1;

    public boolean readFromLog(Iterator it) {
        LRCTFLogEntry e;
        while (it.hasNext() && (e = (LRCTFLogEntry)it.next()).getKey() != 4) {
        }
        if (!it.hasNext()) {
            return false;
        }
        this.state = -1;
        block10: while (it.hasNext()) {
            e = (LRCTFLogEntry)it.next();
            int k = e.getKey();
            switch (k) {
                case 26: {
                    this.red = e.getData(LRCTFLogEntry.D_RED);
                    this.blue = e.getData(LRCTFLogEntry.D_BLUE);
                    continue block10;
                }
                case 25: {
                    int nr = e.getData(LRCTFLogEntry.D_PLAYER);
                    MatchResultSlotEntry se = this.getOrCreateSlotEntry(nr);
                    se.slotNumber = nr;
                    String snew = e.getText();
                    String sold = se.playerName;
                    if (sold != null && e.getText().compareTo(se.playerName) != 0) {
                        System.err.println("name difference for slot #" + nr + ": had " + se.playerName + ", got " + e.getText());
                    }
                    se.playerName = e.getText();
                    se.defense = e.getData(LRCTFLogEntry.D_DEFENSE);
                    se.offense = e.getData(LRCTFLogEntry.D_OFFENSE);
                    se.frags = e.getData(LRCTFLogEntry.D_FRAGS);
                    continue block10;
                }
                case 23: {
                    if (this.MVPO_player != -1) {
                        return false;
                    }
                    this.MVPO_player = e.getData(LRCTFLogEntry.D_PLAYER);
                    continue block10;
                }
                case 24: {
                    if (this.MVPD_player != -1) {
                        return false;
                    }
                    this.MVPD_player = e.getData(LRCTFLogEntry.D_PLAYER);
                    continue block10;
                }
                case 27: {
                    int nr = e.getData(LRCTFLogEntry.D_PLAYER);
                    MatchResultSlotEntry se = this.getOrCreateSlotEntry(nr);
                    se.slotNumber = nr;
                    se.playerName = e.getText();
                    se.score = e.getData(LRCTFLogEntry.D_SCORE);
                    se.ping = e.getData(LRCTFLogEntry.D_PING);
                    continue block10;
                }
                case 3: {
                    this.state = 1;
                    return true;
                }
                default: {
                    continue block10;
                }
                case 1: 
                case 2: 
                case 12: 
            }
            return false;
        }
        return false;
    }

    private MatchResultSlotEntry getOrCreateSlotEntry(int number) {
        MatchResultSlotEntry se;
        if (number >= this.slotData.size()) {
            this.slotData.setSize(number + 1);
        }
        if ((se = (MatchResultSlotEntry)this.slotData.get(number)) == null) {
            se = new MatchResultSlotEntry();
            this.slotData.setElementAt(se, number);
        }
        return se;
    }

    public String toString() {
        MessageFormat lformat = new MessageFormat(LINEFORMATSTRING);
        String s = FIRSTLINEMESSAGE;
        Iterator it = this.slotData.iterator();
        while (it.hasNext()) {
            MatchResultSlotEntry entry = (MatchResultSlotEntry)it.next();
            if (entry == null) continue;
            Object[] objs = new Object[]{new Integer(entry.slotNumber), entry.playerName, new Integer(entry.score), new Integer(entry.offense), new Integer(entry.defense), new Integer(entry.frags), new Integer(entry.ping)};
            s = s + lformat.format(objs, new StringBuffer(), (FieldPosition)null);
        }
        return s;
    }

    public String toHTMLTable() {
        MessageFormat lformat = new MessageFormat(HTML_LINEFORMATSTRING);
        String s = "<table class=matchT><tr><th>Slot</th><th>score</th><th>offense</th><th>defense</th><th>frags</th><th>ping</th></tr>";
        Iterator it = this.slotData.iterator();
        while (it.hasNext()) {
            MatchResultSlotEntry entry = (MatchResultSlotEntry)it.next();
            if (entry == null) continue;
            Object[] objs = new Object[]{new Integer(entry.slotNumber), LROutputHelperHTML.convertQ3ColoursToHTMLwithStyles(entry.playerName), new Integer(entry.score), new Integer(entry.offense), new Integer(entry.defense), new Integer(entry.frags), new Integer(entry.ping)};
            s = s + lformat.format(objs, new StringBuffer(), (FieldPosition)null);
        }
        s = s + "</table>";
        return s;
    }

    public boolean hasSlotEntries() {
        return !this.slotData.isEmpty();
    }

    public int hashCode() {
        int r = this.red * 17 + this.blue * 23 + this.MVPO_player * 59 + this.MVPD_player * 117 + this.slotData.size();
        return r;
    }

    public boolean equals(Object obj) {
        if (obj.getClass().getName().compareTo(this.getClass().getName()) != 0) {
            return false;
        }
        MatchResult mr = (MatchResult)obj;
        if (mr.exitReason != this.exitReason) {
            return false;
        }
        if (mr.red != this.red) {
            return false;
        }
        if (mr.blue != this.blue) {
            return false;
        }
        if (mr.MVPO_player != this.MVPO_player) {
            return false;
        }
        if (mr.MVPD_player != this.MVPD_player) {
            return false;
        }
        if (mr.slotData.size() != this.slotData.size()) {
            return false;
        }
        Iterator it1 = this.slotData.iterator();
        Iterator it2 = mr.slotData.iterator();
        while (it1.hasNext() && it2.hasNext()) {
        }
        return true;
    }

    class MatchResultSlotEntry {
        public int slotNumber = -1;
        public String playerName = null;
        public int score = -1;
        public int defense = -1;
        public int offense = -1;
        public int frags = -1;
        public int ping = -1;

        MatchResultSlotEntry() {
        }
    }
}

