/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.logs;

import com.metabit.naming.util.SimpleNameContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.metabit.tools.games.lrctf.Constants;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.logs.LogEntryHelper;
import org.metabit.tools.games.lrctf.stats.SlotToNameMap;

public class LRCTFMatch
implements Serializable,
Comparable {
    private SlotToNameMap slotnamemap = new SlotToNameMap();
    private int[] stats_generalKillsWithWeapon;
    private String serverName;
    private Date serverStart;
    private Date matchStart;
    private Date matchEnd;
    private long duration;
    private Properties gameSettings;
    private LRCTFLogEntry[] logEntries;
    private String fileName;
    private long matchStartMins;
    private long matchStartSecs;
    private static int MATCHFILE_VERSION = 2;
    static final long serialVersionUID = 2L;
    private static int MAXWEAPON = 32;
    private static SimpleNameContext deathReasons = null;

    public boolean isSane() {
        if (this.matchStart == null) {
            return false;
        }
        return this.matchEnd != null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getMatchStart() {
        return this.matchStart;
    }

    public Date getMatchEnd() {
        return this.matchEnd;
    }

    public Date getServerStart() {
        return this.serverStart;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Properties getSettings() {
        return this.gameSettings;
    }

    public int getNumEntries() {
        return this.logEntries.length;
    }

    public int compareTo(Object o) {
        int val;
        LRCTFMatch m2 = (LRCTFMatch)o;
        if (this.serverName != null && (val = this.serverName.compareTo(m2.getServerName())) != 0) {
            return val;
        }
        Date otherStart = m2.getMatchStart();
        return this.matchStart.compareTo(otherStart);
    }

    public boolean equals(Object obj) {
        LRCTFMatch m2 = (LRCTFMatch)obj;
        if (m2.logEntries.length != this.logEntries.length) {
            return false;
        }
        if (m2.matchStart != this.matchStart) {
            return false;
        }
        if (m2.matchEnd != this.matchEnd) {
            return false;
        }
        if (m2.serverStart != this.serverStart) {
            return false;
        }
        return m2.serverName == this.serverName;
    }

    public String toString() {
        String s = "LRCTF match on server '";
        s = s + this.serverName;
        s = s + "', started ";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        s = s + df.format(this.matchStart);
        if (this.matchEnd != null) {
            s = s + ", ended ";
            s = s + df.format(this.matchEnd);
        } else {
            s = s + "[end time unknown.]";
        }
        s = s + ", with " + this.getNumEntries() + " entries.";
        return s;
    }

    public String getHTMLFilename() {
        Date matchStart = this.getMatchStart();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        String filename = "match_" + df.format(matchStart) + ".html";
        return filename;
    }

    protected void init() {
        if (deathReasons == null) {
            deathReasons = new SimpleNameContext();
            Constants.initDeathReasons(deathReasons);
        }
        this.gameSettings = null;
        this.stats_generalKillsWithWeapon = new int[MAXWEAPON];
        for (int i = 0; i < MAXWEAPON; ++i) {
            this.stats_generalKillsWithWeapon[i] = 0;
        }
    }

    public LRCTFMatch() {
        this.init();
    }

    public LRCTFMatch(List entries) {
        this.init();
        Iterator it = entries.iterator();
        LinkedList<LRCTFLogEntry> temp = new LinkedList<LRCTFLogEntry>();
        boolean firstInit = true;
        boolean properEnd = false;
        boolean continueLoop = true;
        do {
            if (it.hasNext()) {
                LRCTFLogEntry entry = (LRCTFLogEntry)it.next();
                int key = entry.getKey();
                switch (key) {
                    case 1: {
                        if (firstInit) {
                            firstInit = false;
                            temp.add(entry);
                            it.remove();
                            break;
                        }
                        continueLoop = false;
                        break;
                    }
                    case 3: {
                        continueLoop = false;
                        properEnd = true;
                    }
                    default: {
                        temp.add(entry);
                        it.remove();
                        break;
                    }
                }
                continue;
            }
            continueLoop = false;
        } while (continueLoop);
        int numEntries = temp.size();
        this.logEntries = new LRCTFLogEntry[numEntries];
        it = temp.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.logEntries[i] = (LRCTFLogEntry)it.next();
            ++i;
        }
        temp.clear();
        temp = null;
    }

    public boolean postParseEntries() {
        this.postLoadProcessing();
        int num = this.logEntries.length;
        block6: for (int i = 0; i < num; ++i) {
            int key = this.logEntries[i].getKey();
            switch (key) {
                case 1: {
                    if (this.gameSettings != null) {
                        System.err.println("INTERNAL ERROR: InitGame occurring twice in a Match!" + this.fileName);
                        continue block6;
                    }
                    this.gameSettings = LogEntryHelper.parseQ3PropertyString(this.logEntries[i].getText());
                    this.serverName = this.gameSettings.getProperty("sv_hostname");
                    try {
                        long min = this.logEntries[i].getMinute();
                        long sec = this.logEntries[i].getSecond();
                        this.serverStart = new Date();
                        SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
                        String serverstartStr = this.gameSettings.getProperty("gamestartup", this.serverStart.toString());
                        this.serverStart = df.parse(serverstartStr);
                        long tmp = this.serverStart.getTime();
                        tmp += sec * 1000L;
                        this.matchStart = new Date(tmp += min * 60000L);
                        this.matchStartMins = min;
                        this.matchStartSecs = sec;
                    }
                    catch (ParseException pe) {
                        System.err.println("FAILURE! could not calculate date!");
                    }
                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
                    this.fileName = this.serverName.substring(0, 8) + df.format(this.matchStart) + ".ulm";
                    continue block6;
                }
                case 3: 
                case 4: {
                    this.setMatchEnd(this.logEntries[i]);
                }
            }
        }
        if (this.matchStart == null) {
            PrintWriter iCantBelieveThis = new PrintWriter(System.err);
            this.printEntries(iCantBelieveThis);
            iCantBelieveThis.flush();
            return false;
        }
        if (this.matchEnd == null) {
            this.setMatchEnd(this.logEntries[num - 1]);
        }
        return true;
    }

    public void setMatchEnd(LRCTFLogEntry entry) {
        if (this.matchStart == null) {
            System.err.println("fatal exception will occur: no matchStart given!");
        }
        long min = entry.getMinute();
        long sec = entry.getSecond();
        long endTimeL = min * 60L + sec;
        long startTimeL = this.matchStartMins * 60L + this.matchStartSecs;
        this.duration = endTimeL - startTimeL;
        long matchStartTime = this.matchStart.getTime();
        long matchEndTime = matchStartTime + this.duration * 1000L;
        this.matchEnd = new Date(matchEndTime);
    }

    public String getStatsString() {
        String s = "match statistics";
        s = s + "\ngeneral weapon usage";
        for (int i = 0; i < MAXWEAPON; ++i) {
            String t = deathReasons.lookupName(i);
            if (t == null || this.stats_generalKillsWithWeapon[i] == 0) continue;
            s = s + "\ndeath by " + t + ": " + this.stats_generalKillsWithWeapon[i];
        }
        s = s + '\n';
        return s;
    }

    public void printEntries(PrintWriter pw) {
        for (int i = 0; i < this.logEntries.length; ++i) {
            pw.write("#" + i + ": " + this.logEntries[i] + "\n");
        }
        pw.flush();
    }

    protected Vector getEntriesAsVector() {
        if (this.logEntries.length == 0) {
            return new Vector();
        }
        Vector<LRCTFLogEntry> v = new Vector<LRCTFLogEntry>(this.logEntries.length);
        v.setSize(this.logEntries.length);
        for (int i = 0; i < this.logEntries.length; ++i) {
            v.setElementAt(this.logEntries[i], i);
        }
        return v;
    }

    public Iterator iterator() {
        Vector v = this.getEntriesAsVector();
        return v.iterator();
    }

    protected boolean postLoadProcessing() {
        int num = this.logEntries.length;
        block4: for (int i = 0; i < num; ++i) {
            int key = this.logEntries[i].getKey();
            switch (key) {
                case 6: {
                    this.slotnamemap.processLogEntry(this.logEntries[i]);
                    continue block4;
                }
                case 10: {
                    this.slotnamemap.processLogEntry(this.logEntries[i]);
                    continue block4;
                }
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.serverName);
        out.writeObject(this.matchStart);
        out.writeObject(this.matchEnd);
        out.writeObject(this.serverStart);
        out.writeObject(this.gameSettings);
        int numEntries = this.logEntries.length;
        out.writeInt(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            out.writeObject(this.logEntries[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serverName = (String)in.readObject();
        this.matchStart = (Date)in.readObject();
        this.matchEnd = (Date)in.readObject();
        this.serverStart = (Date)in.readObject();
        this.gameSettings = (Properties)in.readObject();
        int numEntries = in.readInt();
        this.logEntries = new LRCTFLogEntry[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            this.logEntries[i] = (LRCTFLogEntry)in.readObject();
        }
        this.postLoadProcessing();
    }

    public void writeToStream(OutputStream ostr) throws IOException {
        DeflaterOutputStream dout = new DeflaterOutputStream(ostr);
        ObjectOutputStream oout = new ObjectOutputStream(dout);
        this.writeObject(oout);
        oout.flush();
        dout.finish();
        dout.flush();
        dout.close();
    }

    public void readFromStream(InputStream istr) throws IOException, ClassNotFoundException {
        InflaterInputStream iistr = new InflaterInputStream(istr);
        ObjectInputStream oin = new ObjectInputStream(iistr);
        this.readObject(oin);
        oin.close();
        iistr.close();
        this.postLoadProcessing();
    }

    public String getPlayerName(int slotNumber) {
        return this.slotnamemap.getName(slotNumber);
    }
}

