/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.metabit.tools.games.lrctf.LRCTFFileFilter;
import org.metabit.tools.games.lrctf.html.LROutputHelperHTML;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.logs.LRCTFMatch;
import org.metabit.tools.games.lrctf.stats.MatchResult;
import org.metabit.tools.games.lrctf.stats.Statistics;

public class Matches2HTMLConverter {
    public static final String FILENAME_MATCHPAGE = "matches.html";
    public static final String FILENAME_MATCHPHP = "match.php";
    public static final String FILENAME_MATCHLIST = "matchlist.php";
    private Statistics stats = null;
    private File outputDir = null;
    private List matchlist = new Vector();
    private File currentFile = null;
    private FileOutputStream fos = null;
    private PrintWriter out = null;

    public Matches2HTMLConverter(File outputDirectory) throws IOException {
        this.outputDir = outputDirectory;
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        if (!this.outputDir.isDirectory()) {
            throw new IOException("outputDir is not a directory!");
        }
    }

    public String convertMatchToHTML(LRCTFMatch match, String filename) throws IOException {
        Iterator it = match.iterator();
        MatchResult mr = new MatchResult();
        mr.readFromLog(it);
        if (mr.hasSlotEntries()) {
            this.openAFile(filename);
            this.out.write("<style>\n");
            this.out.write("Table.matchT { background-color: black; color: white }\n");
            this.out.write("</style>\n");
            this.out.write("<body>\n");
            this.out.write("<hr><h2>results achieved</h2><div>" + match.toString());
            this.out.write("<div>playing map: " + match.getSettings().getProperty("mapname", null) + "</div>\n");
            this.out.write(mr.toHTMLTable());
            this.out.write("</div>");
            this.out.write("<hr><h2>lines spoken</h2><div>");
            Iterator entryIter = match.iterator();
            while (entryIter.hasNext()) {
                LRCTFLogEntry entry = (LRCTFLogEntry)entryIter.next();
                switch (entry.getKey()) {
                    case 10: {
                        this.out.write("\n<br/>");
                        this.out.write(Long.toString(entry.getMinute()));
                        this.out.write(58);
                        this.out.write(Long.toString(entry.getSecond()));
                        this.out.write("\t");
                        String pname = match.getPlayerName(entry.getData(LRCTFLogEntry.D_PLAYER));
                        if (pname != null) {
                            this.out.write(LROutputHelperHTML.convertQ3ColoursToHTMLwithStyles(pname));
                            this.out.write(":");
                        }
                        this.out.write(entry.getText());
                    }
                }
            }
            this.out.write("</div>");
            this.out.write("</body>\n");
            this.closeTheFile();
            MatchListEntry mle = new MatchListEntry(match, filename);
            this.matchlist.add(mle);
        }
        return filename;
    }

    public boolean convertFilesToHTML(File storedir, String extension) {
        if (!storedir.isDirectory()) {
            return false;
        }
        LRCTFFileFilter tf = new LRCTFFileFilter(extension);
        File[] files = storedir.listFiles(tf);
        System.out.println("-- processing " + files.length + " files of type " + extension);
        if (files.length == 0) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                LRCTFMatch m = new LRCTFMatch();
                FileInputStream ifstr = new FileInputStream(files[i]);
                m.readFromStream(ifstr);
                if (m == null) {
                    System.out.println(i + ". :\t" + files[i].getName() + "\t could not be read");
                    continue;
                }
                String fname = m.getHTMLFilename();
                fname = this.convertMatchToHTML(m, fname);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe.getLocalizedMessage());
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.err.println(fnfe.getLocalizedMessage());
                continue;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getLocalizedMessage());
            }
        }
        return true;
    }

    public boolean generateOverviewPage() throws IOException {
        MatchListEntry mle;
        Properties vars = new Properties();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        ((Calendar)calendar).add(5, 1);
        vars.put("now+24h", calendar.getTime().toString());
        vars.put("madeby", "mailto:foo-at-metzelkueche.de");
        vars.put("pagetitle", "LRCTF stats: matches");
        String[] results = LROutputHelperHTML.generateFileFromTemplate("match.html", vars, this.outputDir, FILENAME_MATCHPHP, "***ERROR***");
        if (results.length > 1) {
            System.err.println("errors filling in a template. These keys could not be found:");
            for (int i = 1; i < results.length; ++i) {
                System.err.println("- " + results[i]);
            }
        }
        this.openAFile(FILENAME_MATCHLIST);
        this.out.println("<?php ");
        this.out.println("$matchlist = array(");
        Iterator it = this.matchlist.iterator();
        while (it.hasNext()) {
            mle = (MatchListEntry)it.next();
            this.out.print(mle.toPHPArrayEntry());
            if (!it.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(");");
        this.out.println("?>");
        this.closeTheFile();
        this.openAFile(FILENAME_MATCHPAGE);
        this.out.println("<html><head><title>");
        this.out.print("LRCTF Statistics ");
        this.out.println(" - matches");
        this.out.print("</title></head>");
        this.out.println("<body>");
        this.out.println("<ul>");
        it = this.matchlist.iterator();
        while (it.hasNext()) {
            mle = (MatchListEntry)it.next();
            this.out.print("<li>");
            this.out.print(mle.toHTMLString());
            this.out.println("</li>");
        }
        this.out.println("</ul>");
        this.out.println("</body></html>");
        this.closeTheFile();
        return true;
    }

    protected void openAFile(String filename) throws FileNotFoundException, IOException {
        this.currentFile = new File(this.outputDir, filename);
        this.currentFile.createNewFile();
        this.fos = new FileOutputStream(this.currentFile);
        this.out = new PrintWriter(this.fos);
    }

    protected void closeTheFile() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
        System.gc();
        this.fos.close();
        this.fos = null;
        System.gc();
        long filesize = this.currentFile.length();
        this.currentFile = null;
        System.gc();
    }

    class MatchListEntry {
        public String matchid;
        public String filename;
        public Date matchstart;
        public Date matchend;
        public int entries;
        public Properties settings;

        public MatchListEntry(LRCTFMatch m, String fname) {
            this.matchid = fname.substring(6, 21);
            this.filename = fname;
            this.matchstart = m.getMatchStart();
            this.matchend = m.getMatchEnd();
            this.entries = m.getNumEntries();
            this.settings = m.getSettings();
        }

        public String toHTMLString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<a href=\"" + this.filename + "\">");
            sb.append(this.matchstart.toString());
            sb.append("</a> ");
            sb.append("Duration ");
            long duration = (this.matchend.getTime() - this.matchstart.getTime()) / 1000L;
            sb.append(duration / 60L);
            sb.append(':');
            sb.append(duration % 60L);
            sb.append(", ");
            sb.append(this.entries);
            sb.append(" entries.");
            return sb.toString();
        }

        public StringBuffer toPHPArrayEntry() {
            StringBuffer sb = new StringBuffer();
            sb.append('\"');
            sb.append(this.matchid);
            sb.append('\"');
            sb.append("=>array(");
            this.phpArrayAssignment(sb, "id", this.matchid);
            sb.append(',');
            this.phpArrayAssignment(sb, "file", this.filename);
            sb.append(',');
            this.phpArrayAssignment(sb, "numE", Integer.toString(this.entries));
            sb.append(',');
            this.phpArrayAssignment(sb, "start", this.matchstart.toString());
            sb.append(',');
            long duration = (this.matchend.getTime() - this.matchstart.getTime()) / 1000L;
            this.phpArrayAssignment(sb, "dmin", Long.toString(duration / 60L));
            sb.append(',');
            this.phpArrayAssignment(sb, "dsec", Long.toString(duration % 60L));
            sb.append(')');
            return sb;
        }

        public final void phpArrayAssignment(StringBuffer sb, String name, String value) {
            int DQUOT = 34;
            sb.append('\"');
            sb.append(name);
            sb.append('\"');
            sb.append("=>");
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
        }
    }
}

