/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.metabit.tools.games.lrctf.Config;
import org.metabit.tools.games.lrctf.LRCTFFileFilter;
import org.metabit.tools.games.lrctf.html.LROutputHelperHTML;
import org.metabit.tools.games.lrctf.html.Matches2HTMLConverter;
import org.metabit.tools.games.lrctf.html.Statistics2HTMLConverter;
import org.metabit.tools.games.lrctf.logs.LRCTFLogParser;
import org.metabit.tools.games.lrctf.logs.LRCTFMatch;
import org.metabit.tools.games.lrctf.logs.MatchCollection;
import org.metabit.tools.games.lrctf.logs.PBLogParser;
import org.metabit.tools.games.lrctf.misc.StatsCalculator;
import org.metabit.tools.games.lrctf.stats.Statistics;
import org.metabit.tools.games.lrctf.stats.StatsSet;
import org.metabit.tools.games.lrctf.stats.TimeIntervalStats;

public class LRCTFStats {
    static final String DATE = "$Date: 2004/07/30 19:12:48 $";
    static final String REVISION = "$Revision: 1.41 $";

    public static final String getProgramRevision() {
        String t = new String(REVISION);
        t = t.replace('$', ' ');
        t = t.replaceFirst("Revision:", " ");
        return t.trim();
    }

    public static void main(String[] args) {
        Config cfg = null;
        File storeDir = null;
        File outputDir = null;
        try {
            cfg = new Config(args);
        }
        catch (Exception e) {
            System.err.println("internal error. We need at least some settings.");
            System.err.println(e.getLocalizedMessage());
            return;
        }
        if (cfg == null) {
            System.err.println("internal error initializing config. aborting");
            return;
        }
        if (!cfg.getBoolean("quiet") && !cfg.checkAction(8)) {
            System.out.println(cfg.getString("title"));
            System.out.println("Version: " + LRCTFStats.getProgramRevision());
            String greeting = LROutputHelperHTML.getTextResourceAsString("/org/metabit/tools/games/lrctf/greeting.txt");
            if (greeting != null) {
                System.out.print(greeting);
            }
        }
        try {
            storeDir = LRCTFStats.getOrCreateDirectory(cfg.getString("storeDir"));
            outputDir = LRCTFStats.getOrCreateDirectory(cfg.getString("outputDir"));
        }
        catch (IOException ioe) {
            System.err.println(ioe.getLocalizedMessage());
            return;
        }
        if (cfg.checkAction(0)) {
            System.out.println("fooStats");
            System.out.println("parser and statistics generator for Lokis Revenge CTF");
            System.out.println("2004 by J.Wilkes @ metabit for metzelkueche.de");
            System.out.println("");
            String helptext = LROutputHelperHTML.getTextResourceAsString("/org/metabit/tools/games/lrctf/help.txt");
            if (helptext != null) {
                System.out.println(helptext);
            }
            System.out.println("give names of actions LRCTFstats should perform");
            System.out.print("possible actions are: ");
            String[] actions = cfg.getValidActions();
            for (int i = 0; i < actions.length; ++i) {
                System.out.print(actions[i] + " ");
            }
            System.out.println();
        }
        if (cfg.checkAction(4)) {
            System.out.println("working on: TEST");
            String template = "bla fasel ${test} s\u00fclz 1234${suck}89 fail: ${fail} $ { } end test.";
            Properties varset = new Properties();
            varset.put("test", "some test value");
            varset.put("suck", "567");
            String[] results = LROutputHelperHTML.fillInVariables(template, varset, "ERROR");
            System.out.println(results[0]);
            LRCTFStats.testStuff(storeDir);
        }
        if (cfg.checkAction(6)) {
            String filename = cfg.getString("Q3logfile", "q3lrctf-games.log");
            System.out.println("working on: PARSE, file to parse is '" + filename + "'.");
            LRCTFStats.doStreamingLogParsingOnFile(cfg, filename, storeDir);
        }
        if (cfg.checkAction(5)) {
            System.out.println("working on: LIST");
            LRCTFStats.listFiles(storeDir);
        }
        if (cfg.checkAction(7)) {
            System.out.println("working on: STATS");
            LRCTFStats.actionStats(storeDir, outputDir);
            System.out.println("STATS done.");
        }
    }

    public static void doPBLogParsingOnFile(String filename) {
        try {
            FileInputStream pbfile = new FileInputStream(filename);
            PBLogParser pbparser = new PBLogParser();
            pbparser.parseStream(pbfile);
        }
        catch (IOException ioe2) {
            System.err.println("IOException occurred.");
            System.err.println(ioe2.getLocalizedMessage());
            ioe2.printStackTrace(System.err);
            Object ioe2 = null;
            return;
        }
    }

    public static boolean actionStats(File storeDir, File outputDir) {
        if (!storeDir.isDirectory()) {
            return false;
        }
        if (!outputDir.isDirectory()) {
            return false;
        }
        Statistics stats = new Statistics();
        System.out.println("- setting up time frames for stats");
        stats.add(new TimeIntervalStats());
        GregorianCalendar somewhen = new GregorianCalendar(2004, 6, 1);
        stats.add(new TimeIntervalStats(somewhen.getTime(), 2678400L));
        System.out.println("- processing matches");
        stats.processFilesForStats(storeDir, ".ulm");
        stats.processFilesForStats(storeDir, ".lrm");
        System.out.println("- calculating statistics (not implemented yet)");
        System.out.println("- generating output");
        try {
            Statistics2HTMLConverter stats2html = new Statistics2HTMLConverter(outputDir);
            stats2html.convertStatisticsToHTML(stats);
            Matches2HTMLConverter matches2html = new Matches2HTMLConverter(outputDir);
            matches2html.convertFilesToHTML(storeDir, ".ulm");
            matches2html.convertFilesToHTML(storeDir, ".lrm");
            matches2html.generateOverviewPage();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getLocalizedMessage());
            ioe.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean testStuff(File storedir) {
        StatsSet set1 = new StatsSet();
        set1.createIntItem(0);
        set1.createIntItem(1);
        set1.createIntItem(2);
        set1.updateIntItem(1, 345);
        set1.updateIntItem(1, 56);
        set1.updateIntItem(1, 456);
        System.err.println(set1.toDebugString());
        if (!storedir.isDirectory()) {
            return false;
        }
        System.out.println("processing stored files");
        LRCTFFileFilter tf = new LRCTFFileFilter(".lrm");
        File[] files = storedir.listFiles(tf);
        for (int i = 0; i < files.length; ++i) {
            try {
                LRCTFMatch m = new LRCTFMatch();
                FileInputStream ifstr = new FileInputStream(files[i]);
                m.readFromStream(ifstr);
                if (m == null) {
                    System.out.println(i + ". :\t" + files[i].getName() + "\t could not be read");
                } else {
                    System.out.println(i + ". :\t" + files[i].getName() + "\t has " + m.getNumEntries() + " entries.");
                }
                m = null;
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe.getLocalizedMessage());
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.err.println(fnfe.getLocalizedMessage());
                continue;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getLocalizedMessage());
            }
        }
        System.out.println("processing of stored files finished.");
        return true;
    }

    protected static void doStreamingLogParsingOnFile(Config cfg, String filename, File storeDir) {
        boolean verbose = cfg.getBoolean("verbose");
        try {
            FileInputStream fis = new FileInputStream(filename);
            LRCTFLogParser lparser = new LRCTFLogParser(fis);
            Object o = lparser.singlePassParseMatch();
            while (o != null) {
                boolean r;
                LRCTFMatch match = (LRCTFMatch)o;
                match.postParseEntries();
                if (verbose) {
                    System.err.println("writing file " + match.getFileName() + ", " + match.getNumEntries() + " entries.");
                }
                if (!(r = LRCTFStats.storeMatchIntoFile(match, storeDir, true))) {
                    System.err.println("problem storing match");
                }
                o = lparser.singlePassParseMatch();
            }
        }
        catch (IOException ioe) {
            System.err.println("IO Exception:");
            System.err.println(ioe.getLocalizedMessage());
            ioe.printStackTrace(System.err);
        }
    }

    public static boolean storeMatchIntoFile(LRCTFMatch m, File storeDir, boolean verifywriting) {
        block14: {
            try {
                if (!storeDir.isDirectory()) {
                    System.err.println(storeDir.getCanonicalPath() + " is not a directory.");
                    return false;
                }
                if (!storeDir.canWrite()) {
                    System.err.println(storeDir.getCanonicalPath() + " is not writable.");
                    return false;
                }
                if (!m.isSane()) {
                    System.out.println("had to skip this match because it lacks start and/or end: " + m.toString());
                    return false;
                }
                String ofname = m.getFileName();
                if (ofname != null) {
                    FileInputStream ifstr;
                    File ofile = new File(storeDir, ofname);
                    boolean overwrite = true;
                    if (ofile.exists()) {
                        LRCTFMatch m2 = new LRCTFMatch();
                        ifstr = new FileInputStream(ofile);
                        try {
                            m2.readFromStream(ifstr);
                            if (m.equals(m2)) {
                                overwrite = false;
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            System.err.println(cnfe.getLocalizedMessage());
                            overwrite = true;
                        }
                    }
                    if (overwrite) {
                        FileOutputStream ofstr = new FileOutputStream(ofile);
                        m.writeToStream(ofstr);
                        ofstr.flush();
                        ofstr.close();
                        ofstr = null;
                    }
                    if (!verifywriting) break block14;
                    int numBefore = m.getNumEntries();
                    ifstr = new FileInputStream(ofile);
                    try {
                        m.readFromStream(ifstr);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.err.println(cnfe.getLocalizedMessage());
                    }
                    int numAfter = m.getNumEntries();
                    if (numBefore != numAfter) {
                        System.err.println(ofname + " had errors when writing. Should have been " + numBefore + " entries, was " + numAfter);
                    }
                    break block14;
                }
                System.err.println("emptyname! " + m.getNumEntries());
                m.printEntries(new PrintWriter(System.out));
            }
            catch (IOException ioe) {
                System.err.println("IO Exception:");
                System.err.println(ioe.getLocalizedMessage());
                ioe.printStackTrace(System.err);
            }
        }
        return true;
    }

    public static void parseAndStoreQ3File(String filename, File storeDir) {
        MatchCollection mc1 = LRCTFStats.doLogParsingOnFile(filename);
        System.out.println("- storing matches");
        LRCTFStats.storeMatchesIntoFiles(mc1, storeDir);
    }

    public static MatchCollection doLogParsingOnFile(String filename) {
        MatchCollection lc = new MatchCollection();
        try {
            FileInputStream fis = new FileInputStream(filename);
            LRCTFLogParser lparser = new LRCTFLogParser(fis);
            System.out.println("- pass 1: parsing log file");
            List entries = lparser.pass1();
            System.out.println("  read " + entries.size() + " log file entries.");
            System.out.println("- pass 2: grouping log entries to matches");
            Vector v = lparser.pass2(entries);
            System.out.println("  parsed " + v.size() + " LRCTF matches");
            for (int i = 0; i < v.size(); ++i) {
                LRCTFMatch m = (LRCTFMatch)v.get(i);
                lc.addMatch(m);
            }
            lparser = null;
            fis.close();
            fis = null;
            System.out.println("- parsing finished.");
            return lc;
        }
        catch (IOException ioe) {
            System.err.println("IO Exception:");
            System.err.println(ioe.getLocalizedMessage());
            ioe.printStackTrace(System.err);
            return lc;
        }
    }

    public static void storeMatchesIntoFiles(MatchCollection mc, File storeDir) {
        try {
            if (!storeDir.isDirectory()) {
                System.err.println(storeDir.getCanonicalPath() + " is not a directory.");
                return;
            }
            if (!storeDir.canWrite()) {
                System.err.println(storeDir.getCanonicalPath() + " is not writable.");
                return;
            }
            Iterator it = mc.iterator();
            while (it.hasNext()) {
                LRCTFMatch m = (LRCTFMatch)it.next();
                if (!m.isSane()) {
                    System.out.println("had to skip this match because it lacks start and/or end: " + m.toString());
                    continue;
                }
                String ofname = m.getFileName();
                if (ofname != null) {
                    int numAfter;
                    FileInputStream ifstr;
                    File ofile = new File(storeDir, ofname);
                    boolean overwrite = true;
                    if (ofile.exists()) {
                        LRCTFMatch m2 = new LRCTFMatch();
                        ifstr = new FileInputStream(ofile);
                        try {
                            m2.readFromStream(ifstr);
                            if (m.equals(m2)) {
                                overwrite = false;
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            System.err.println(cnfe.getLocalizedMessage());
                            overwrite = true;
                        }
                    }
                    if (overwrite) {
                        FileOutputStream ofstr = new FileOutputStream(ofile);
                        m.writeToStream(ofstr);
                        ofstr.flush();
                        ofstr.close();
                        ofstr = null;
                    }
                    int numBefore = m.getNumEntries();
                    ifstr = new FileInputStream(ofile);
                    try {
                        m.readFromStream(ifstr);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.err.println(cnfe.getLocalizedMessage());
                    }
                    if (numBefore == (numAfter = m.getNumEntries())) continue;
                    System.err.println(ofname + " had errors when writing. Should have been " + numBefore + " entries, was " + numAfter);
                    continue;
                }
                System.err.println("emptyname! " + m.getNumEntries());
                m.printEntries(new PrintWriter(System.out));
            }
            System.out.println("- matches stored.");
            System.out.flush();
        }
        catch (IOException ioe) {
            System.err.println("IO Exception:");
            System.err.println(ioe.getLocalizedMessage());
            ioe.printStackTrace(System.err);
        }
    }

    public static void testSomeOutput(MatchCollection lc, File outputDir) {
        MatchCollection test1 = lc.getDaySubset(2004, 5, 25);
        if (test1 != null) {
            System.out.println("jetzt nur der 25.");
            test1.printOut(System.out);
            Iterator it = test1.iterator();
            while (it.hasNext()) {
                LRCTFMatch m = (LRCTFMatch)it.next();
            }
            System.out.println();
        }
        if (test1 != null) {
            StatsCalculator scalc = new StatsCalculator();
            try {
                scalc.evaluateMatches(test1);
            }
            catch (IOException ioe) {
                System.err.println(ioe.getLocalizedMessage());
            }
        }
    }

    public static void listFiles(File storedir) {
        System.out.println("listing stored files:");
        System.out.println("* listing unchecked matches");
        LRCTFStats.listFilesofType(storedir, ".ulm");
        System.out.println("* listing punkbuster data");
        LRCTFStats.listFilesofType(storedir, ".pbl");
        System.out.println("* listing complete lrctf matches");
        LRCTFStats.listFilesofType(storedir, ".lrm");
        System.out.println("listing of stored files finished.");
    }

    public static boolean listFilesofType(File storedir, String extension) {
        if (!storedir.isDirectory()) {
            return false;
        }
        LRCTFFileFilter tf = new LRCTFFileFilter(extension);
        File[] files = storedir.listFiles(tf);
        if (files.length == 0) {
            System.out.println("- no files of this type -");
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                LRCTFMatch m = new LRCTFMatch();
                FileInputStream ifstr = new FileInputStream(files[i]);
                m.readFromStream(ifstr);
                if (m == null) {
                    System.out.println(i + ". :\t" + files[i].getName() + "\t could not be read");
                } else {
                    System.out.println(i + ". :\t" + files[i].getName() + "\t has " + m.getNumEntries() + " entries.");
                }
                m = null;
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe.getLocalizedMessage());
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.err.println(fnfe.getLocalizedMessage());
                continue;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getLocalizedMessage());
            }
        }
        return true;
    }

    public static File getOrCreateDirectory(String dirname) throws IOException {
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }
}

